import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import cnrg.itx.datax.Stats;
import java.util.*;

/**
 * This class can take a variable number of parameters on the command
 * line. Program execution begins with the main() method. The class
 * constructor is not invoked unless an object of type 'Stats'
 * created in the main() method.
 */
public class StatsDialog extends Form implements Observer
{
   public void update(Observable o, Object arg) 
   {
	  Stats s = (Stats)arg;
	  String temp[] = new String[1];
	  listView1.removeAllItems();
	  for(Enumeration e = s.statKeys(); e.hasMoreElements();) 
	  {
		  String currKey = (String)e.nextElement();
		  temp[0] = s.getStat(currKey).toString();
		  listView1.addItem(currKey, -1, temp);
	  }
   }
	
	public StatsDialog()
	{
		super();

		// Required for Visual J++ Form Designer support
		initForm();		

		// TODO: Add any constructor code after initForm call
	}

	/**
	 * Stats overrides dispose so it can clean up the
	 * component list.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	ListView listView1 = new ListView();
	ColumnHeader columnHeader1 = new ColumnHeader();
	ColumnHeader columnHeader2 = new ColumnHeader();

	private void initForm()
	{
		this.setText("Stats");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setClientSize(new Point(311, 319));

		columnHeader1.setText("Name");
		columnHeader1.setWidth(197);

		columnHeader2.setText("Value");
		columnHeader2.setWidth(110);

		listView1.setDock(ControlDock.FILL);
		listView1.setSize(new Point(311, 319));
		listView1.setTabIndex(0);
		listView1.setText("listView1");
		listView1.setBorderStyle(BorderStyle.FIXED_SINGLE);
		listView1.setGridLines(true);
		listView1.setHeaderStyle(ColumnHeaderStyle.NONCLICKABLE);
		listView1.setView(ViewEnum.REPORT);
		listView1.setColumns(new ColumnHeader[] {
							 columnHeader1, 
							 columnHeader2});

		this.setNewControls(new Control[] {
							listView1});
	}
}
